package com.module;

import java.io.IOException;
import java.util.Map;

import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

import com.principal.HelloWorldUser;
import com.principal.HelloWorldRole;

public class DummyLoginModule implements LoginModule {
	
	private Subject subject;
	private CallbackHandler callbackHandler;
	private Map<String, ?> sharedState;
	private Map<String, ?> options;
	
	private HelloWorldUser myUser;
	private HelloWorldRole myRole;
	private boolean success;
	
	@Override
	public void initialize(Subject subject, CallbackHandler callbackHandler,
			Map<String, ?> sharedState, Map<String, ?> options) {
		this.subject = subject;
		this.callbackHandler = callbackHandler;
		this.sharedState = sharedState;
		this.options = options;	
		success = false;
	}

    /**
     * <p> Verify the password against the relevant JDBC datasource.
     *
     * @return true always, since this <code>LoginModule</code>
     *      should not be ignored.
     *
     * @exception FailedLoginException if the authentication fails. <p>
     *
     * @exception LoginException if this <code>LoginModule</code>
     *      is unable to perform the authentication.
     */
	@Override
	public boolean login() throws LoginException {
		
		if ( callbackHandler == null ) {
			throw new LoginException("no handler");
		}
		
		// Callback is just like a VO object, that the handler will populate!
		NameCallback nameCallback=new NameCallback("username");
		PasswordCallback passwordCallback=new PasswordCallback("password", false);
		Callback[] callbacks = new Callback[] { nameCallback, passwordCallback };
		
		try {
		
			callbackHandler.handle(callbacks);
		
		} catch (IOException e) {
			
			throw new LoginException("handler io error");
		
		} catch (UnsupportedCallbackException e) {
		
			throw new LoginException("unsupported callback error");
		
		}
		
		String username = nameCallback.getName();
		String password = new String(passwordCallback.getPassword());
		
		if ( options.get("username").equals(username) && options.get("password").equals(password) ) {
			
			// add these if commit was called!
			myUser=new HelloWorldUser(username);
			myRole=new HelloWorldRole(String.valueOf(options.get("role")));
			
			success = true;
				
		} else {
			
			throw new LoginException("incorrect username/password");

		}
		
		return true;
	}

    /**
     * Abstract method to commit the authentication process (phase 2).
     *
     * <p> This method is called if the LoginContext's
     * overall authentication succeeded
     * (the relevant REQUIRED, REQUISITE, SUFFICIENT and OPTIONAL LoginModules
     * succeeded).
     *
     * <p> If this LoginModule's own authentication attempt
     * succeeded (checked by retrieving the private state saved by the
     * <code>login</code> method), then this method associates a
     * <code>MyUserPrincipal</code>
     * with the <code>Subject</code> located in the
     * <code>LoginModule</code>.  If this LoginModule's own
     * authentication attempted failed, then this method removes
     * any state that was originally saved.
     *
     * <p>
     *
     * @exception LoginException if the commit fails
     *
     * @return true if this LoginModule's own login and commit
     *      attempts succeeded, or false otherwise.
     */
	@Override
	public boolean commit() throws LoginException {
		
		if ( success ) {
			
			subject.getPrincipals().add(myUser);
			subject.getPrincipals().add(myRole);
			
			return true;
		}
		
		return false;
	}

    /**
     * <p> This method is called if the LoginContext's
     * overall authentication failed.
     * (the relevant REQUIRED, REQUISITE, SUFFICIENT and OPTIONAL LoginModules
     * did not succeed).
     *
     * <p> If this LoginModule's own authentication attempt
     * succeeded (checked by retrieving the private state saved by the
     * <code>login</code> and <code>commit</code> methods),
     * then this method cleans up any state that was originally saved.
     *
     * <p>
     *
     * @exception LoginException if the abort fails.
     *
     * @return false if this LoginModule's own login and/or commit attempts
     *     failed, and true otherwise.
     */
	@Override
	public boolean abort() throws LoginException {
		
		if ( success ) {
			
			callbackHandler = null;
			sharedState = null;
			options = null;
			
			myUser = null;
			myRole = null;
			
			return true;
		}
	
		return false;
	
	}

    /**
     * Logout a user.
     *
     * <p> This method removes the Principals
     * that were added by the <code>commit</code> method.
     *
     * <p>
     *
     * @exception LoginException if the logout fails.
     *
     * @return true in all cases since this <code>LoginModule</code>
     *		should not be ignored.
     */
	@Override
	public boolean logout() throws LoginException {
		
		callbackHandler = null;
		sharedState = null;
		options = null;
		
		success = false;
		
		subject.getPrincipals().remove(myUser);
		subject.getPrincipals().remove(myRole);
		
		myUser = null;
		myRole = null;

		return true;
	
	}

}
