/*
 * Decompiled with CFR 0.152.
 */
package com.module;

import com.principal.HelloWorldRole;
import com.principal.HelloWorldUser;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class DummyLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, ?> sharedState;
    private Map<String, ?> options;
    private HelloWorldUser myUser;
    private HelloWorldRole myRole;
    private boolean success;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.success = false;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("no handler");
        }
        NameCallback nameCallback = new NameCallback("username");
        PasswordCallback passwordCallback = new PasswordCallback("password", false);
        Callback[] callbacks = new Callback[]{nameCallback, passwordCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw new LoginException("handler io error");
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException("unsupported callback error");
        }
        String username = nameCallback.getName();
        String password = new String(passwordCallback.getPassword());
        if (!this.options.get("username").equals(username) || !this.options.get("password").equals(password)) {
            throw new LoginException("incorrect username/password");
        }
        this.myUser = new HelloWorldUser(username);
        this.myRole = new HelloWorldRole(String.valueOf(this.options.get("role")));
        this.success = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.success) {
            this.subject.getPrincipals().add(this.myUser);
            this.subject.getPrincipals().add(this.myRole);
            return true;
        }
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.success) {
            this.callbackHandler = null;
            this.sharedState = null;
            this.options = null;
            this.myUser = null;
            this.myRole = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        this.callbackHandler = null;
        this.sharedState = null;
        this.options = null;
        this.success = false;
        this.subject.getPrincipals().remove(this.myUser);
        this.subject.getPrincipals().remove(this.myRole);
        this.myUser = null;
        this.myRole = null;
        return true;
    }
}

