package com.napp;

import java.sql.* ;
import java.util.Properties;

/**
 * @author neville m
 * 
 * DerbyEmbeddedClient
 *	dbName - Database name (its a path!)
 *	createDB - Create DB if doesnt exist
 *	createTables - Create table
 *	insertTables - Insert Table
 *	displayTables - Display table
 *	dropTables - Drop table
 *
 */
public class DerbyEmbeddedClient
{
	String dbName;
	boolean createDB;
	
	boolean createTables;
	boolean insertTables;
	boolean displayTables;
	boolean dropTables;
	
	public DerbyEmbeddedClient(String dbName, boolean createDB, boolean createTables, boolean insertTables, boolean displayTables, boolean dropTables) {
		this.dbName = dbName;
		this.createDB = createDB;
		
		this.createTables = createTables;
		this.insertTables = insertTables;
		this.displayTables = displayTables;
		this.dropTables = dropTables;
	}
	
	public void execute() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
			
			// Loading this driver will start up the DerbyEngine!
			// Please specify any static Derby system properties before hand!
			Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            System.out.println("EmbeddedDriver loaded, derby engine! has begun!!!");
			
            // Username and Password are optional in embedded and derbyclient
            // If we're creating DB, following is the username and password used to connect to it.
            // I think by default passwords are ignored but please do your own research!
            Properties props = new Properties();
            props.put("user", "user1");
            props.put("password", "user1");
			
            // Get a connection to the database
            String protocol = "jdbc:derby:";
   
            // The name of the database. A folder with this name will be created! where? in the derby.system.home or user.dir.
            // It also seems to recognize absolute and relative paths. So if i had dbName=c:/db/derby, it would end up at c:/db/derby
            // String dbName = "db/derbyDB";
            
            // create = true means if this database doesn't exist create it!
            // So in a scenario where you would probably use an installer to create your database this parameter will be true
            // However when you connect to the derby DB from your app, this parameter would usually be false.
            Connection conn = null;
            if ( createDB ) {
            	conn = DriverManager.getConnection(protocol + dbName + ";create=true", props);
            } else {
            	conn = DriverManager.getConnection(protocol + dbName + ";", props);
            }
            
            JdbcCode jdbccode=new JdbcCode();
            jdbccode.execute(conn, "usertable", createTables, insertTables, displayTables, dropTables);
            
            conn.close() ;
			
	}
	
	public static void main( String args[] ) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException
	{
		System.setProperty("derby.system.home", "c:/derbydb");
		
		// Using the EmbeddedClientDriver
		// Create DB db/derbyDB if not created, and create, insert, display and drop 'usertable' in the DB.
		DerbyEmbeddedClient dec=new DerbyEmbeddedClient("db/derbyDB", true, true, true, true, true);
		dec.execute();
		
		// You cannot change derby.system.home after loading the EmbeddedDriver. Even after doing this DerbyEmbeddedClient
		// will yet be pointing to c:/derbydb
		System.setProperty("derby.system.home", "c:/derbydb2");
		dec=new DerbyEmbeddedClient("db/derbyDB", true, true, true, true, true);
		dec.execute();
	}
}
