package com.napp;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

/**
 * @author neville m
 *
 * DerbyNetworkClient
 *	dbName - Database name (its a path!)
 *	createDB - Create DB if doesnt exist
 *	createTables - Create table
 *	insertTables - Insert Table
 *	displayTables - Display table
 *	dropTables - Drop table
 */
public class DerbyNetworkClient {
	
	String dbName;
	boolean createDB;
	String ip;
	int port;
	
	boolean createTables;
	boolean insertTables;
	boolean displayTables;
	boolean dropTables;
	
	public DerbyNetworkClient(String ip, int port, String dbName, boolean createDB, boolean createTables, boolean insertTables, boolean displayTables, boolean dropTables) {
		this.dbName = dbName;
		this.createDB = createDB;
		this.ip = ip;
		this.port = port;
		
		this.createTables = createTables;
		this.insertTables = insertTables;
		this.displayTables = displayTables;
		this.dropTables = dropTables;
	}
	
	public void execute() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
			
			// Load driver to connect to Network DB server!
			// Please specify any static Derby system properties before hand!
			Class.forName("org.apache.derby.jdbc.ClientDriver").newInstance();
            System.out.println("ClientDriver loaded, ready to connect!");
			
            // Username and Password are optional in embedded and derbyclient
            // If we're creating DB, following is the username and password used to connect to it.
            // I think by default passwords are ignored but please do your own research!
            Properties props = new Properties();
            props.put("user", "user1");
            props.put("password", "pass1");
			
            // Get a connection to the database
            // jdbc:derby://HOST:PORT/
            String protocol = "jdbc:derby://" + ip + ":" + port + "/";
   
            // The name of the database. A folder with this name will be created! where? in the derby.system.home (of server) or user.dir (where server is started)!.
            // It also seems to recognize absolute and relative paths. So if i had dbName=c:/db/derby, it would end up at c:/db/derby (on the server!)
            // String dbName = "db/derbyDB";
            
            // create = true means if this database doesn't exist create it!
            // So in a scenario where you would probably use an installer to create your database this parameter will be true
            // However when you connect to the derby DB from your app, this parameter would usually be false.
            Connection conn = null;
            
            if ( createDB ) {
            	conn = DriverManager.getConnection(protocol + dbName + ";create=true", props);            
            } else {
            	conn = DriverManager.getConnection(protocol + dbName + ";", props);  
            }
            
            JdbcCode jdbccode=new JdbcCode();
            jdbccode.execute(conn, "usertable", createTables, insertTables, displayTables, dropTables);
            
            conn.close() ;
			
	}	
	
	public static void main(String[] args) throws Exception {
		
		//Start DerbyNetworkServer
		DerbyNetworkServer dServer=new DerbyNetworkServer(1527, "user", "pass");
		Thread server=new Thread(dServer);
		server.start();
		
		//You can use the DerbyNetworkClient to connect to DerbyNetworkServer
		//If the process is in the same JVM, you could even use the DerbyEmbeddedClient!
		//Lets use both!

		// Using the ClientDriver, connect to DB at localhost at port 1527. Create db with name "db/derbyDB" if not created (on the server!).
		// Then within that schema create and display 'usertable'
		DerbyNetworkClient den = null;		
		den=new DerbyNetworkClient("localhost", 1527, "db/derbyDB", true, true, false, true, false);
		den.execute();
		
		// Using the EmbeddedClientDriver
		// Within db db/derbyDB insert into 'usertable'
		DerbyEmbeddedClient dec=new DerbyEmbeddedClient("db/derbyDB", false, false, true, false, false);
		dec.execute();

		// Using the ClientDriver, connect to DB at localhost at port 1527. Create db with name "db/derbyDB" if not created (on the server!).
		// Within db db/derbyDB display and drop 'usertable'
		den=new DerbyNetworkClient("localhost", 1527, "db/derbyDB", false, false, false, true, true);
		den.execute();
		
		dServer.shutdown();
		
	}
	
}

