package com.napp;

import java.io.PrintWriter;
import java.net.InetAddress;

import org.apache.derby.drda.NetworkServerControl;

/**
 * @author neville m 
 * Class to start DerbyNetworkServer at localhost with port, username and password!
 *
 */
public class DerbyNetworkServer implements Runnable
{
	int port;
	String user;
	String pass;
	NetworkServerControl server;
	
	public DerbyNetworkServer(int port, String user, String pass) {
		this.port = port;
		this.user = user;
		this.pass = pass;
		this.server = null;
	}
	
	public void run() {
		try {
			//start network server!
			System.out.println("Starting Derby Network Server");			
			server=new NetworkServerControl(InetAddress.getByName("localhost"), port, user, pass);
			server.start(new PrintWriter(System.out));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void shutdown() throws Exception {
		server.shutdown();
		System.out.println("DerbyNetworkServer shutdown");
	}
	
}
