package com.napp;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * Simple class to create, insert, display, drop a table
 * @author neville m
 *
 */
public class JdbcCode {
	
	public void execute( Connection conn, String table, boolean create, boolean insert, boolean display, boolean drop ) throws SQLException {
		
		Statement stat = conn.createStatement();
		
		if ( create ) {
			System.out.println("create table " + table + " (id int, username varchar(10)) ");           
			stat.execute("create table " + table + " (id int, username varchar(10)) ");
		}
		
		PreparedStatement preparedStat= null;
        if ( insert ) {
        	System.out.println("insert into " + table + " values (?, ?)");    
        	preparedStat = conn.prepareStatement("insert into " + table + " values (?, ?)");
	        preparedStat.setInt(1, 0);
	        preparedStat.setString(2, "user1");
	        preparedStat.execute();
	        preparedStat.setInt(1, 1);
	        preparedStat.setString(2, "user2");            
	        preparedStat.execute();
	        preparedStat.close();
        }
        
        ResultSet rs = null;
        if ( display ) {
	        rs = stat.executeQuery( "SELECT * FROM " + table ) ;        
	        System.out.println("SELECT * FROM " + table);            
	        while( rs.next() ) {
	        	System.out.println( rs.getString(1) + " " + rs.getString(2) ) ;
	        }
	        rs.close() ;
        }
        
        if ( drop ) {
        	System.out.println("drop table " + table);
        	stat.execute("drop table " + table);
        }
                	
        stat.close() ;
        
	}
	
}
